/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.IWSTypeEntry;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSType;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.wsdl.symbolTable.CollectionElement;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.symbolTable.Utils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSElementDecl
implements IWSTypeEntry {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSElementDecl";
    private WSDefinition m_definition = null;
    private WSType m_type = null;
    private ElementDecl m_elementDecl = null;
    private IWSTypeEntry[] m_references = null;
    private TypeEntry m_collectionTypeEntry = null;
    private boolean m_bAttachmentReference = false;
    private boolean m_bXMLString = false;
    private String m_maxOccurs = "1";
    private String m_minOccurs = "1";

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:00:22  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.17  $";
    }

    public void releaseReferences() {
        block5: {
            try {
                WSType type = null;
                IWSTypeEntry typeEntry = null;
                this.m_definition = null;
                if (this.m_type != null) {
                    type = this.m_type;
                    this.m_type = null;
                    type.releaseReferences();
                }
                this.m_elementDecl = null;
                if (this.m_references != null) {
                    IWSTypeEntry[] references = this.m_references;
                    this.m_references = null;
                    for (int i = 0; i < references.length; ++i) {
                        typeEntry = references[i];
                        if (typeEntry == null) continue;
                        references[i] = null;
                        typeEntry.releaseReferences();
                        typeEntry = null;
                    }
                    Object var3_4 = null;
                }
                this.m_collectionTypeEntry = null;
                this.m_maxOccurs = null;
                this.m_minOccurs = null;
                type = null;
                Object var2_3 = null;
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block5;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSElementDecl(WSDefinition definition, ElementDecl elementDecl, Type parentType) {
        Object name;
        this.m_definition = definition;
        this.m_elementDecl = elementDecl;
        TypeEntry typeEntry = elementDecl.getType();
        if (this.m_definition != null && typeEntry != null) {
            name = typeEntry.getQName();
            Vector<IWSTypeEntry> references = new Vector<IWSTypeEntry>();
            TypeEntry refTypeEntry = elementDecl.getType();
            if (refTypeEntry != null && refTypeEntry instanceof CollectionElement) {
                this.m_collectionTypeEntry = refTypeEntry;
            }
            references.add(this.m_definition.getTypeEntry(refTypeEntry));
            while (refTypeEntry != null) {
                if ((refTypeEntry = refTypeEntry.getRefType()) == null) continue;
                references.add(this.m_definition.getTypeEntry(refTypeEntry));
            }
            if (references != null && references.size() > 0) {
                this.m_references = new IWSTypeEntry[references.size()];
                references.toArray(this.m_references);
                references.removeAllElements();
            }
            if (this.m_collectionTypeEntry != null) {
                String occurs = null;
                occurs = Utils.getAttribute((Node)this.m_collectionTypeEntry.getNode(), (String)"maxOccurs");
                this.m_maxOccurs = occurs != null && occurs.length() > 0 ? occurs : "unbounded";
                occurs = Utils.getAttribute((Node)this.m_collectionTypeEntry.getNode(), (String)"minOccurs");
                this.m_minOccurs = occurs != null && occurs.length() > 0 ? occurs : "1";
            } else {
                this.m_maxOccurs = this.getType().getMaxOccurs();
                this.m_minOccurs = this.getType().getMinOccurs();
            }
        }
        if ((name = this.m_elementDecl.getQName().getLocalPart()) != null && parentType != null) {
            Node element;
            Node node;
            int index = ((String)name).lastIndexOf(">");
            if (index != -1) {
                name = ((String)name).substring(index + 1);
            }
            if ((node = parentType.getNode()) != null && (element = this.getChildElementWithName(node, "element", (String)name)) != null) {
                String value;
                NamedNodeMap attribs;
                Node refAttrib;
                Node appinfo;
                Node annotation = this.getChildElement(element, "annotation");
                if (annotation != null && (appinfo = this.getChildElement(annotation, "appinfo")) != null) {
                    Node typeName = this.getChildElementWithName(appinfo, "processType", "attachmentRef");
                    if (typeName != null) {
                        this.m_bAttachmentReference = true;
                    }
                    if ((typeName = this.getChildElementWithName(appinfo, "processType", "xmlString")) != null) {
                        this.m_bXMLString = true;
                    }
                }
                if ((refAttrib = (attribs = element.getAttributes()).getNamedItem("ref")) != null && (value = refAttrib.getNodeValue()) != null) {
                    if (value.indexOf("attachmentRef") != -1) {
                        this.m_bAttachmentReference = true;
                    } else if (value.indexOf("xmlString") != -1) {
                        this.m_bXMLString = true;
                    }
                }
            }
        }
    }

    private Node getChildElement(Node node, String tag) {
        return this.getChildElementWithName(node, tag, null);
    }

    private Node getChildElementWithName(Node node, String tag, String name) {
        if (node != null && tag != null) {
            NodeList nodelist = node.getChildNodes();
            Node aNode = null;
            String nodename = null;
            if (nodelist != null) {
                for (int i = 0; i < nodelist.getLength(); ++i) {
                    aNode = nodelist.item(i);
                    if (aNode.getNodeType() != 1) continue;
                    nodename = aNode.getNodeName();
                    if (nodename != null && nodename.indexOf(tag) != -1) {
                        if (name != null) {
                            String value;
                            NamedNodeMap attribs = aNode.getAttributes();
                            Node nameAttrib = attribs.getNamedItem("name");
                            if (nameAttrib != null && (value = nameAttrib.getNodeValue()) != null && value.compareTo(name) == 0) {
                                return aNode;
                            }
                        } else {
                            return aNode;
                        }
                    }
                    if ((aNode = this.getChildElementWithName(aNode, tag, name)) == null) continue;
                    return aNode;
                }
            }
        }
        return null;
    }

    public String getName() {
        QName name;
        if (this.m_elementDecl != null && (name = this.m_elementDecl.getQName()) != null) {
            return name.getLocalPart();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.m_elementDecl.getQName() != null) {
            return this.m_elementDecl.getQName().getLocalPart();
        }
        return null;
    }

    public ElementDecl getElementDecl() {
        return this.m_elementDecl;
    }

    public WSType getType() {
        IWSTypeEntry typeEntry;
        if (this.m_type == null && this.m_references != null && this.m_references.length > 0 && (typeEntry = this.m_references[this.m_references.length - 1]) != null && typeEntry instanceof WSType) {
            this.m_type = (WSType)typeEntry;
        }
        return this.m_type;
    }

    public IWSTypeEntry[] getReferences() {
        return this.m_references;
    }

    public String toString() {
        if (this.m_elementDecl.getQName() != null) {
            return this.m_elementDecl.getQName().toString();
        }
        return null;
    }

    public String getNamespace() {
        if (this.m_elementDecl != null && this.m_elementDecl.getQName() != null) {
            return this.m_elementDecl.getQName().getNamespaceURI();
        }
        return null;
    }

    public String getNamespacePrefix() {
        String namespace = this.getNamespace();
        if (namespace != null && namespace.length() > 0 && this.m_definition != null) {
            return this.m_definition.getNamespacePrefix(namespace);
        }
        return null;
    }

    public boolean isXMLString() {
        return this.m_bXMLString;
    }

    public boolean isAttachmentReference() {
        return this.m_bAttachmentReference;
    }

    WSDefinition getDefinition() {
        return this.m_definition;
    }

    public boolean isCollectionParent(boolean bRPC) {
        if (this.m_type != null) {
            return this.m_type.isCollectionParent(bRPC);
        }
        return false;
    }

    public boolean isCollectionElement() {
        if (this.m_collectionTypeEntry != null) {
            return true;
        }
        if (this.m_type != null) {
            return this.m_type.isCollectionElement();
        }
        return false;
    }

    public QName getQName() {
        return this.m_elementDecl.getQName();
    }

    public String getTypeLocalName() {
        return this.m_elementDecl.getQName().getLocalPart();
    }

    public String getMaxOccurs() {
        return this.m_maxOccurs;
    }

    public String getMinOccurs() {
        return this.m_minOccurs;
    }
}

